<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HmoProposedLicenceHolder extends Model 
{

    protected $table = 'hmo_proposed_licence_holders';
    public $timestamps = true;
    protected $fillable = array('hmo_form_id', 'title', 'name', 'telephone', 'email');

    public function hmoForm()
    {
        return $this->belongsTo('HmoForm', 'hmo_form_id');
    }

    public function plhAddress()
    {
        return $this->morphOne('Address', 'addressable');
    }

}